/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.legacy;

import com.floragunn.searchguard.SearchGuardModule;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.DlsFlsProcessedConfig;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.support.SgUtils;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.Index;
import org.elasticsearch.threadpool.ThreadPool;

public class FlsQueryCacheWeightProvider
implements SearchGuardModule.QueryCacheWeightProvider {
    private final ThreadPool threadPool;
    private final AtomicReference<DlsFlsProcessedConfig> config;

    FlsQueryCacheWeightProvider(ThreadPool threadPool, AtomicReference<DlsFlsProcessedConfig> config) {
        this.threadPool = threadPool;
        this.config = config;
    }

    public Weight apply(Index index, Weight weight, QueryCachingPolicy policy) {
        if (!this.config.get().isEnabled()) {
            return null;
        }
        Map allowedFlsFields = (Map)((Object)HeaderHelper.deserializeSafeFromHeader((ThreadContext)this.threadPool.getThreadContext(), (String)"_sg_fls_fields"));
        if (SgUtils.evalMap((Map)allowedFlsFields, (String)index.getName()) != null) {
            return weight;
        }
        Map maskedFieldsMap = (Map)((Object)HeaderHelper.deserializeSafeFromHeader((ThreadContext)this.threadPool.getThreadContext(), (String)"_sg_masked_fields"));
        if (SgUtils.evalMap((Map)maskedFieldsMap, (String)index.getName()) != null) {
            return weight;
        }
        return null;
    }
}

